﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;

namespace IndianHealthService.BMXNet.WinForm.Model
{
    internal class WinObject
    {
        private string _Ien = "";

        public string Ien
        {
            get { return _Ien; }
            set { _Ien = value; }
        }

        private RemoteSession _remoteSession = null;

        public RemoteSession RemoteSession
        {
            get { return _remoteSession; }
            set { _remoteSession = value; }
        }

        public override bool Equals(object obj)
        {
            if (this.Ien == "" || this.Ien == null)
            {

                return false;
            }
            else
            {
                WinObject other = obj as WinObject;

                if (other == null)
                {
                    return false;
                }

                if (this.GetType().IsAssignableFrom(other.GetType()) || this.GetType().IsAssignableFrom(other.GetType()))
                {

                    return this.Ien.Equals(other.Ien, StringComparison.InvariantCultureIgnoreCase);
                }
                else
                {
                    return false;
                }
            }
        }

        public override int GetHashCode()
        {
            return this.Ien.GetHashCode();
        }
    }
}
